/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.problem;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.pa.persist.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.pa.persist.ProblemPersistenceException;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkEvent;
import com.ibm.hwmca.fw.util.WorkListener;
import com.ibm.hwmca.fw.util.WorkPerformer;
import com.ibm.hwmca.fw.util.WorkThread;
import com.ibm.hwmca.fw.util.XMLEncodeableArrayList;
import com.ibm.hwmca.p.pa.event.PelDataEvent;
import com.ibm.hwmca.p.pa.event.SaelDataEvent;
import com.ibm.hwmca.p.pa.fru.PIFru;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.util.CeComment;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OEMProblemDescription
implements Runnable,
PropertyChangeListener,
WorkPerformer,
WorkListener {
    private static final String TRACE_MASKT = "XPAOEMST";
    private static final String TRACE_MASKF = "XPAOEMSF";
    private static final String TRACE_MASKD = "XPAOEMSD";
    private static final String DFC_OEM_PROBLEM_DIR = "oemproblemdir";
    private static final String IBM_SERVICE_FILE = "/opt/hsc/data/ibmserviced.dat";
    private static final String OEM_PROBLEM_PROGRAM = "/opt/hsc/bin/callsa";
    private static String OEMProblemDir = null;
    private static final String startDelim = "<==>";
    private static final String delim = ";";
    private static final char delimChar = ';';
    private static final String endDelim = "<=;=>";
    private static final String TIMESTAMP_PATTERN = "MM/dd/yyyy HH:mm:ss";
    private static final long SLEEP_INTERVAL = 1000L;

    public void run() {
        Trace.trace(TRACE_MASKT, "-> run()");
        if (!new File(IBM_SERVICE_FILE).exists()) {
            Trace.trace(TRACE_MASKF, "OEM environment; about to register with ProblemManager");
            OEMProblemDescription listener = this;
            boolean done = false;
            while (!done) {
                try {
                    ProblemManager.getProblemManager().addPropertyChangeListener(listener);
                    done = true;
                    Trace.trace(TRACE_MASKF, "Registered for PropertyChangeEvents");
                }
                catch (PersistenceNotInitializedException pnie) {
                    Trace.trace(TRACE_MASKF, "Unable to get ProblemManager right now; sleep and try again soon");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                    }
                }
                catch (ProblemPersistenceException ppe) {
                    Trace.trace(TRACE_MASKF, "Unable to get ProblemManager; cannot register OEM listener");
                    done = true;
                }
            }
        } else {
            Trace.trace(TRACE_MASKF, "Not an OEM environment; do not register with ProblemManager");
        }
        Trace.trace(TRACE_MASKT, "<- run()");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Trace.trace(TRACE_MASKT, "->propertyChange()");
        if (evt.getOldValue() instanceof CommonProblem) {
            CommonProblem p = (CommonProblem)evt.getOldValue();
            if (evt.getPropertyName().equals("ProblemOpenProperty")) {
                Trace.trace(TRACE_MASKF, "Event for opening a CommonProblem");
                if (OEMProblemDir == null) {
                    try {
                        Trace.trace(TRACE_MASKF, "Find the OEM problem description directory");
                        OEMProblemDir = BaseFileControl.getFilePath(DFC_OEM_PROBLEM_DIR);
                    }
                    catch (HException he) {
                        Trace.trace(TRACE_MASKF, "DFC lookup for oemproblemdir failed");
                    }
                }
                if (OEMProblemDir != null) {
                    WorkThread.invokeAsync(this, this, p, "OEM Problem Notification thread");
                }
            } else {
                Trace.trace(TRACE_MASKF, "Some event other than an OPEN");
            }
        } else {
            Trace.trace(TRACE_MASKF, "Some type other than a CommonProblem");
        }
        Trace.trace(TRACE_MASKT, "<-propertyChange()");
    }

    public Object performWork(Object parms) {
        Trace.trace(TRACE_MASKT, "-> performWork(" + parms + ")");
        CommonProblem p = (CommonProblem)parms;
        String problemDescriptionFile = OEMProblemDir + "error" + p.getProblemNumber() + ".dat";
        try {
            PASystem system;
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(problemDescriptionFile), "UTF-8"));
            Trace.trace(TRACE_MASKF, "About to write Problem description file: " + problemDescriptionFile);
            CommonDataEvent primaryDataEvent = p.getPrimaryDataEvent();
            SaelDataEvent sael = null;
            PelDataEvent pel = null;
            if (primaryDataEvent != null) {
                if (primaryDataEvent instanceof SaelDataEvent) {
                    sael = (SaelDataEvent)primaryDataEvent;
                } else if (primaryDataEvent instanceof PelDataEvent) {
                    pel = (PelDataEvent)primaryDataEvent;
                }
            }
            if ((system = p.getFailingSystem()) != null) {
                this.writeString(w, "FDMachineType", system.getMachineType());
                this.writeString(w, "FDMachineModel", system.getMachineModel());
                this.writeString(w, "FDMachineSerial", system.getMachineSerial());
            } else {
                this.writeString(w, "FDMachineType", "");
                this.writeString(w, "FDMachineModel", "");
                this.writeString(w, "FDMachineSerial", "");
            }
            this.writeBoolean(w, "EverCallHome", p.isCallHome());
            this.writeBoolean(w, "CalledHome", p.getPMH() != null);
            String temp = p.getDescription().toString();
            if (temp == null) {
                temp = "none";
            }
            if (temp != null && temp.length() > 54) {
                this.writeString(w, "Description", temp.substring(0, 54));
                this.writeString(w, "Detail-Description", temp);
            } else {
                this.writeString(w, "Description", temp);
            }
            this.writeBoolean(w, "EEDOnly", false);
            this.writeTimestamp(w, "LastReportedTimeStamp", p.getLastReportedTimestamp());
            HMC hmc = HMC.getHMC();
            this.writeString(w, "HSCId", hmc.getMachineType() + hmc.getMachineModel());
            this.writeString(w, "HSCName", hmc.getMachineSerial());
            List frus = p.getParts();
            if (frus != null && frus.size() > 0) {
                int fruCount = frus.size();
                String[] FRUCCINs = new String[fruCount];
                String[] FRUEnclosureMachineTypeModels = new String[fruCount];
                String[] FRUEnclosureMachineSerialNumbers = new String[fruCount];
                String[] FRULogicControllingCECMachineTypeModels = new String[fruCount];
                String[] FRULogicControllingCECMachineSerialNumbers = new String[fruCount];
                String[] FRUPowerControllingCECMachineTypeModels = new String[fruCount];
                String[] FRUPowerControllingCECMachineSerialNumbers = new String[fruCount];
                String[] FRUPartNumbers = new String[fruCount];
                String[] FRUPartNumberReplaces = new String[fruCount];
                boolean[] FRURecentlyReplaceds = new boolean[fruCount];
                long[] FRUReplaceTimestamps = new long[fruCount];
                String[] FRUAddLocations = new String[fruCount];
                String[] FRUAddPartNumbers = new String[fruCount];
                long[] FRUAddReplaceTimestamps = new long[fruCount];
                String[] FRUClasss = new String[fruCount];
                long[] FRUReplacementPrioritys = new long[fruCount];
                String[] FRUConcurrentMaintenances = new String[fruCount];
                String[] FRUDescriptions = new String[fruCount];
                String[] FRUSerialNumbers = new String[fruCount];
                Iterator it = frus.iterator();
                for (int i = 0; i < fruCount; ++i) {
                    CommonPaFru fru = (CommonPaFru)it.next();
                    system = fru.getEnclosureSystem();
                    if (system != null) {
                        FRUEnclosureMachineTypeModels[i] = system.getMachineType() + "-" + system.getMachineModel();
                        FRUEnclosureMachineSerialNumbers[i] = system.getMachineSerial();
                    } else {
                        FRUEnclosureMachineTypeModels[i] = null;
                        FRUEnclosureMachineSerialNumbers[i] = null;
                    }
                    FRUPartNumbers[i] = fru.getPartNumber();
                    ArrayList locations = fru.getLocationList();
                    if (locations != null) {
                        Iterator iter = locations.iterator();
                        while (iter.hasNext()) {
                            FRUPartNumbers[i] = FRUPartNumbers[i] + " " + (String)iter.next();
                        }
                    }
                    FRUPartNumberReplaces[i] = fru.getPreviousPartNumber();
                    FRURecentlyReplaceds[i] = fru.isReplacedPrior();
                    FRUReplaceTimestamps[i] = fru.getReplacedTimeStamp();
                    FRUAddLocations[i] = null;
                    FRUAddPartNumbers[i] = null;
                    FRUAddReplaceTimestamps[i] = 0L;
                    FRUConcurrentMaintenances[i] = null;
                    FRUDescriptions[i] = fru.getDescription();
                    FRUSerialNumbers[i] = fru.getSerialNumber();
                    if (fru instanceof PIFru) {
                        PIFru pifru = (PIFru)fru;
                        FRUCCINs[i] = pifru.getCCIN();
                        system = pifru.getLogicControllingSystem();
                        if (system != null) {
                            FRULogicControllingCECMachineTypeModels[i] = system.getMachineType() + "-" + system.getMachineModel();
                            FRULogicControllingCECMachineSerialNumbers[i] = system.getMachineSerial();
                        } else {
                            FRULogicControllingCECMachineTypeModels[i] = null;
                            FRULogicControllingCECMachineSerialNumbers[i] = null;
                        }
                        system = pifru.getPowerControllingSystem();
                        if (system != null) {
                            FRUPowerControllingCECMachineTypeModels[i] = system.getMachineType() + "-" + system.getMachineModel();
                            FRUPowerControllingCECMachineSerialNumbers[i] = system.getMachineSerial();
                        } else {
                            FRUPowerControllingCECMachineTypeModels[i] = null;
                            FRUPowerControllingCECMachineSerialNumbers[i] = null;
                        }
                        FRUClasss[i] = pifru.getLocalizableFruClass().toString();
                        FRUReplacementPrioritys[i] = pifru.getNumericPriority();
                    }
                    this.writeString(w, "RefCode", p.getRefcode());
                }
                this.writeMultiValueString(w, "FRUCCIN", FRUCCINs);
                this.writeMultiValueString(w, "FRUEnclosureMachineTypeModel", FRUEnclosureMachineTypeModels);
                this.writeMultiValueString(w, "FRUEnclosureMachineSerialNumber", FRUEnclosureMachineSerialNumbers);
                this.writeMultiValueString(w, "FRULogicControllingCECMachineTypeModel", FRULogicControllingCECMachineTypeModels);
                this.writeMultiValueString(w, "FRULogicControllingCECMachineSerialNumber", FRULogicControllingCECMachineSerialNumbers);
                this.writeMultiValueString(w, "FRUPowerControllingCECMachineTypeModel", FRUPowerControllingCECMachineTypeModels);
                this.writeMultiValueString(w, "FRUPowerControllingCECMachineSerialNumber", FRUPowerControllingCECMachineSerialNumbers);
                this.writeMultiLineString(w, "FRUPartNumber", FRUPartNumbers);
                this.writeMultiValueString(w, "FRUPartNumberReplace", FRUPartNumberReplaces);
                this.writeMultiValueBoolean(w, "FRURecentlyReplaced", FRURecentlyReplaceds);
                this.writeMultiValueTimestamp(w, "FRUReplaceTimestamp", FRUReplaceTimestamps);
                this.writeMultiValueString(w, "FRUAddLocation", FRUAddLocations);
                this.writeMultiValueString(w, "FRUAddPartNumber", FRUAddPartNumbers);
                this.writeMultiValueTimestamp(w, "FRUAddReplaceTimestamp", FRUAddReplaceTimestamps);
                this.writeMultiValueString(w, "FRUClass", FRUClasss);
                this.writeMultiValueNumeric(w, "FRUReplacementPriority", FRUReplacementPrioritys);
                this.writeMultiValueString(w, "FRUConcurrentMaintenance", FRUConcurrentMaintenances);
                this.writeMultiValueString(w, "FRUDescription", FRUDescriptions);
                this.writeMultiValueString(w, "FRUSerialNumber", FRUSerialNumbers);
            }
            if (sael != null) {
                int ssid = sael.getSubsystemID();
                String errorCode = sael.getAIXErrorCode();
            }
            this.writeTimestamp(w, "OriginalTimeStamp", p.getFirstReportedTimestamp());
            system = p.getReportingRemoteMachineSystem();
            if (system != null) {
                this.writeString(w, "CECMachineType", system.getMachineType());
                this.writeString(w, "CECMachineModel", system.getMachineModel());
                this.writeString(w, "CECMachineSerialNumber", system.getMachineSerial());
            }
            this.writeTimestamp(w, "CreatedTimeStamp", p.getProblemTimeStamp());
            this.writeNumeric(w, "DuplicateCount", p.getDuplicateCount());
            List problemDataDescriptors = p.getProblemDataSet();
            if (problemDataDescriptors != null) {
                Iterator iter = problemDataDescriptors.iterator();
                int count = problemDataDescriptors.size();
                String[] files = new String[count];
                for (int i = 0; i < count; ++i) {
                    ProblemDataDescriptor desc = (ProblemDataDescriptor)iter.next();
                    files[i] = desc.getName();
                }
                this.writeMultiLineString(w, "ExtendedErrorData", files);
            }
            this.writeString(w, "DumpID", p.getDumpLocation());
            this.writeString(w, "HMCNameContainingDumpFile", hmc.getDisplayableName().toString());
            if (sael != null) {
                this.writeString(w, "CreatorID", sael.getCreatorID());
                this.writeString(w, "SymptomString", sael.getSymptomString());
                this.writeString(w, "ErrorLabel", sael.getErrorLogLabel());
                this.writeNumeric(w, "ErrorSequence", sael.getSeqNum());
                this.writeString(w, "OSType", sael.getPartitionOSType());
                this.writeString(w, "PartitionID", sael.getPartitionID());
                this.writeString(w, "PartitionName", sael.getPartitionName());
                this.writeString(w, "HostName", sael.getPartitionHostName());
            } else if (pel != null) {
                this.writeString(w, "CreatorID", pel.getCreatorID());
            }
            this.writeString(w, "SystemRefCode", p.getSRC());
            this.writeString(w, "PMHNumber", p.getPMH());
            if (p instanceof PIProblem) {
                PIProblem pip = (PIProblem)p;
                Set systems = pip.getAssociatedCECSystems();
                if (systems != null && systems.size() > 0) {
                    int count = systems.size();
                    String[] values = new String[count];
                    Iterator it = systems.iterator();
                    for (int i = 0; i < count; ++i) {
                        system = (PASystem)it.next();
                        values[i] = system.getMachineType() + "-" + system.getMachineModel() + "-" + system.getMachineSerial();
                    }
                    this.writeMultiValueString(w, "FDAdditionalMachine", values);
                }
                if ((system = pip.getClusterSystem()) != null) {
                    this.writeString(w, "ClusterMachineTypeModel", system.getMachineType() + "-" + system.getMachineModel());
                    this.writeString(w, "ClusterMachineSerialNumber", system.getMachineSerial());
                }
                this.writeString(w, "FederationNetworkID", pip.getSwitchNetworkID());
                XMLEncodeableArrayList comments = pip.getCeComments();
                if (comments != null && comments.size() > 0) {
                    int count = comments.size();
                    String[] CEDataNames = new String[count];
                    String[] CEDataTexts = new String[count];
                    long[] CEDataTimestamps = new long[count];
                    for (int i = 0; i < count; ++i) {
                        CeComment comment = (CeComment)comments.get(i);
                        CEDataNames[i] = comment.getCeName();
                        CEDataTexts[i] = comment.getCeComment();
                        CEDataTimestamps[i] = comment.getCeCommentTimeStamp();
                    }
                    this.writeMultiLineString(w, "CEDataName", CEDataNames);
                    this.writeMultiLineString(w, "CEDataText", CEDataTexts);
                    this.writeMultiLineTimestamp(w, "CEDataTimestamp", CEDataTimestamps);
                }
                this.writeString(w, "PlatformLogID", pip.getPlatformLogID());
                this.writeString(w, "SubsystemID", pip.getSubsystemID());
                this.writeString(w, "EventSeverity", pip.getEventSeverity());
            }
            w.close();
            Trace.trace(TRACE_MASKF, "Done writing file; about to invoke OEM program");
            try {
                Process proc = Runtime.getRuntime().exec("/opt/hsc/bin/callsa -f " + problemDescriptionFile);
                int rc = OEMProblemDescription.getExitStatus(proc);
                Trace.trace(TRACE_MASKF, "Exit status from /opt/hsc/bin/callsa = " + rc);
                new File(problemDescriptionFile).delete();
            }
            catch (IOException npioe) {
                Trace.trace(TRACE_MASKF, "IOException occurred while trying to invoke /opt/hsc/bin/callsa: " + npioe);
            }
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, "IOException occurred while writing " + problemDescriptionFile + ": " + ioe);
        }
        Trace.trace(TRACE_MASKT, "<- performWork");
        return null;
    }

    public void workCompleted(WorkEvent ev) {
        Trace.trace(TRACE_MASKT, "<-> workCompleted");
    }

    private void writeString(BufferedWriter w, String key, String value) throws IOException {
        if (value != null) {
            w.write(key + startDelim + value + endDelim);
            w.newLine();
        }
    }

    private void writeNumeric(BufferedWriter w, String key, long value) throws IOException {
        w.write(key + startDelim + value + endDelim);
        w.newLine();
    }

    private void writeBoolean(BufferedWriter w, String key, boolean value) throws IOException {
        w.write(key + startDelim + (value ? "Yes" : "No") + endDelim);
        w.newLine();
    }

    private void writeTimestamp(BufferedWriter w, String key, long value) throws IOException {
        if (value != 0L) {
            SimpleDateFormat timestampFormatter = new SimpleDateFormat(TIMESTAMP_PATTERN);
            w.write(key + startDelim + timestampFormatter.format(new Date(value)) + endDelim);
            w.newLine();
        }
    }

    private void writeMultiLineString(BufferedWriter w, String key, String[] values) throws IOException {
        if (values != null) {
            int i;
            boolean found = false;
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null || values[i].length() == 0) continue;
                found = true;
                break;
            }
            if (found) {
                w.write(key + startDelim);
                w.newLine();
                for (i = 0; i < values.length; ++i) {
                    String value = values[i];
                    w.write(" " + (value == null ? "" : value.replace(';', '.') + " ") + delim);
                    w.newLine();
                }
                w.write(" <=;=>");
                w.newLine();
            }
        }
    }

    private void writeMultiLineString(BufferedWriter w, String key, List values) throws IOException {
        if (values != null && values.size() > 0) {
            int count = values.size();
            String[] strings = new String[count];
            Iterator it = values.iterator();
            for (int i = 0; i < count; ++i) {
                strings[i] = (String)it.next();
            }
            this.writeMultiLineString(w, key, strings);
        }
    }

    private void writeMultiValueString(BufferedWriter w, String key, String[] values) throws IOException {
        if (values != null) {
            int i;
            boolean found = false;
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null || values[i].length() == 0) continue;
                found = true;
                break;
            }
            if (found) {
                w.write(key + startDelim);
                for (i = 0; i < values.length; ++i) {
                    String value = values[i];
                    w.write(" " + (value == null ? "" : value.replace(';', '.') + " ") + delim);
                }
                w.write(" <=;=>");
                w.newLine();
            }
        }
    }

    private void writeMultiValueBoolean(BufferedWriter w, String key, boolean[] values) throws IOException {
        if (values != null) {
            w.write(key + startDelim);
            for (int i = 0; i < values.length; ++i) {
                boolean value = values[i];
                w.write(" " + (value ? "Yes " : "No ") + delim);
            }
            w.write(" <=;=>");
            w.newLine();
        }
    }

    private void writeMultiLineTimestamp(BufferedWriter w, String key, long[] values) throws IOException {
        if (values != null) {
            boolean found = false;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == 0L) continue;
                found = true;
                break;
            }
            if (found) {
                SimpleDateFormat timestampFormatter = new SimpleDateFormat(TIMESTAMP_PATTERN);
                w.write(key + startDelim);
                w.newLine();
                for (int i = 0; i < values.length; ++i) {
                    long value = values[i];
                    w.write(" " + timestampFormatter.format(new Date(value)) + " " + delim);
                    w.newLine();
                }
                w.write(" <=;=>");
                w.newLine();
            }
        }
    }

    private void writeMultiValueTimestamp(BufferedWriter w, String key, long[] values) throws IOException {
        if (values != null) {
            boolean found = false;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == 0L) continue;
                found = true;
                break;
            }
            if (found) {
                SimpleDateFormat timestampFormatter = new SimpleDateFormat(TIMESTAMP_PATTERN);
                w.write(key + startDelim);
                for (int i = 0; i < values.length; ++i) {
                    long value = values[i];
                    w.write(" " + timestampFormatter.format(new Date(value)) + " " + delim);
                }
                w.write(" <=;=>");
                w.newLine();
            }
        }
    }

    private void writeMultiValueNumeric(BufferedWriter w, String key, long[] values) throws IOException {
        if (values != null) {
            w.write(key + startDelim);
            for (int i = 0; i < values.length; ++i) {
                long value = values[i];
                w.write(" " + value + " " + delim);
            }
            w.write(" <=;=>");
            w.newLine();
        }
    }

    private static int getExitStatus(Process proc) {
        Trace.trace(TRACE_MASKT, "->getExitStatus()");
        boolean done = false;
        int exitStatus = -1;
        while (!done) {
            try {
                exitStatus = proc.waitFor();
                done = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        Trace.trace(TRACE_MASKT, "<-getExitStatus() returning " + exitStatus);
        return exitStatus;
    }
}

